const path = require("path");

/**
 * 用法
 * bun test.js [appName] [method] [param]
 * [appName]: 相对目录下的小组件目录名
 * [method]: 需要测试的方法名称 home | list {type_id} | detail {vod_id} | search {keyword} | similar {type_id} | play {vod_id}
 * [param]: 需要测试的参数
 */
(async () => {
    const [, , appName, method, param] = process.argv;

    if (!appName) {
        console.error("请提供要测试的应用名称");
        process.exit(1);
    }
    if (!method) {
        console.error("请提供要执行的方法名称");
        process.exit(1);
    }

    const config = require(path.resolve(appName, "config.json"));
    globalThis.config = config;

    if (config.ext && config.play_function) {
        globalThis.ext = require(path.resolve(appName, config.ext));
    }

    const widget = require("./core/index.js");

    // # 首页接口数据测试
    if (method === "home") {
        const home = await widget.home();
        console.log(JSON.stringify(home, null, 2));
    }

    // # type_id 列表测试
    if (method === "list") {
        const data = await widget.list(param, 1);
        console.log(data);
    }

    // # 详情页接口数据测试
    if (method === "detail") {
        const detail = await widget.detail({
            vod_id: param
        });
        console.log(JSON.stringify(detail, null, 2));
    }

    // # 搜索关键字测试
    if (method === "search") {
        const search = await widget.search(param, 1);
        console.log(JSON.stringify(search, null, 2));
    }

    // # 关键词相似影片测试
    if (method === "similar") {
        const similar = await widget.similar({
            vod_id: param
        });
        console.log(similar);
    }

    if (method === "play") {
        const play = await widget.play({
            url: param
        });
        console.log(JSON.stringify(play, null, 2));
    }
})();
