/**
 * 点击播放时，会带回detail分集的url
 * @param {*} url
 */
async function getPlayUrl(url) {
    const response = await $fetch(`https://duboku.info${url}`);
    const html = await response.text();
    const { document } = DOMParser(html);
    const $script = xpath(document, [
        "//div[contains(@class, 'myui-player__box')]//script"
    ])[0];
    let playUrl = "";
    if ($script) {
        const content = xpath($script, ".//text()")?.toString()?.trim();
        if (content.indexOf("var player_aaaa=") !== -1) {
            const json = JSON.parse(content.substring(content.indexOf("{")));
            if (json && json.url) {
                playUrl = json.url;
            }
        }
    }
    return playUrl;
}

function getDetailSource(html, _params) {
    const { document } = DOMParser(html);
    const vod_sources = [];
    const $sources = xpath(document, "//ul[contains(@class, 'nav-tabs')]/li");
    for (let i = 0, len = $sources.length; i < len; i++) {
        const $source = $sources[i];

        const source_name = xpath($source, "./a/text()")?.toString()?.trim();

        if (
            source_name &&
            !source_name.includes("无广告") &&
            source_name !== "JY线路"
        ) {
            const source = {
                source_name: source_name,
                vod_play_list: {
                    url_count: 0,
                    urls: []
                }
            };
            const $links = xpath(
                $source,
                "//div[contains(@class,'tab-content')]/div[contains(@class, 'tab-pane')][{index}]//li".replace(
                    /{index}/g,
                    i + 1
                )
            );
            source.vod_play_list.url_count = $links.length;
            $links.forEach($link => {
                const url = {
                    name: xpath($link, "./a/text()")?.toString()?.trim(),
                    url: xpath($link, "./a/@href")[0]?.value?.trim()
                };
                source.vod_play_list.urls.push(url);
            });
            $links.length && vod_sources.push(source);
        }
    }

    return vod_sources;
}

module.exports.getPlayUrl = getPlayUrl;
module.exports.getDetailSource = getDetailSource;
